 aR  w ` mP9      h	 o_       nSystem-wide$PAGEWIDTH (150)

    NAME Intrcept_SysDep

; This module contains routines that may be
; different depending on what machine Interceptor
; is run on.  This module should eventually handle
; both the Compass and the IBM PC.

DGROUP GROUP DATA
CGROUP GROUP CODE

; Exported calls

    PUBLIC CpEnableInterrupt, CpDisableInterrupt
    PUBLIC CpSetInterrupt, CpEndOfInterrupt
    PUBLIC CpMachineID
    PUBLIC WinGetWindowExtent, WinInvertRectangle
    PUBLIC SysDepPatchCalls, SysDepUnPatchCalls
    PUBLIC timeSlice, timerIntSegAddr

    EXTRN  charDevAlias: BYTE
$EJECT

; Memory mapped I/O address and I/O ports

; machine ID

machIDSeg    EQU 0DFF4H
machIDStart  EQU 1

; interrupt ID's

int8087       EQU 0
intGpib       EQU 1
intKeyboard   EQU 2  ; (Never used on CCCOS)
intSysTick    EQU 3  ; (intVertSync on compass)
intModem      EQU 4
intBubble     EQU 5  ; (Never used on CCCOS)
intSerial     EQU 6
intRing       EQU 7

; 8-15 are mapped as logical 8-15 = physical 0-7

; glitch interrupt value

intGlitch     EQU 7

; interrupt controller 

interruptInit EQU 0
interruptOper EQU 2

interruptEOI  EQU 0
intMask       EQU 2

; interrupt controller bytes

icw1          EQU 013H      ; edge triggered, single 8259, ICW4 needed
icw2          EQU 078H      ; use interrupts 78H through ??H
icw4          EQU 00DH      ; 8086 mode, normal EOI, buffered mode
ocw1          EQU 0FFH      ; enable no interrupts


DATA SEGMENT PUBLIC 'DATA'

timeSlice       DW 16         ; 16 for Compass
timerIntSegAddr DW 1ECH       ; (icw2 + interruptTable (intSysTick)) * 4

DATA ENDS
$EJECT


CODE SEGMENT PUBLIC 'CODE'
     ASSUME CS:CGROUP, DS:DGROUP

; interrupt table
; This table will map a virtual interrupt ID to its real priority mask
; 99 means unused

interruptTable DB   6,  5,  4,  3,  2,  1,  0,   7,  0,  1,  2,  3,  4,  5,  6,   7

; This table is the same as interruptTable except everything is a power of 2

interruptMask  DB  64, 32, 16,  8,  4,  2,  1, 128,  1,  2,  4,  8, 16, 32, 64, 128

; Variables stored in code segment


adrPdtPrnOff DW ?
adrPdtPrnSeg DW ?

oldPdtPrnOff DW ?
oldPdtPrnSeg DW ?
$EJECT

;    CpEnableInterrupt: PROCEDURE (interruptID,mode) CLEAN;
;        DCL interruptID BYTE;
;        DCL mode        BYTE;
;
;    This will enable the interrupt of the given ID.  It will not
;    change the state of any other interrupts.

mode        EQU BYTE PTR [BP+6]
interruptID EQU BYTE PTR [BP+8]

CpEnableInterrupt PROC NEAR
    PUSH DS
    PUSH BP
    MOV  BP, SP

    MOV  BL, interruptID
    MOV  BH, 0
    MOV  AL, CS:interruptMask[BX]   ; AL = mask

    NOT  AL                         ; prepare for reseting bit

    MOV  AH, AL

    PUSHF                           ; save flag state
    CLI                             ; disable interrupts
    IN   AL, intMask                ; get current mask
    AND  AL, AH
    OUT  intMask, AL                ; AND then output it
    POPF                            ; restore flags

    POP  BP
    POP  DS
    RET  4
CpEnableInterrupt ENDP

PURGE mode, interruptID
$EJECT

;    CpDisableInterrupt: PROCEDURE (interruptID) CLEAN;
;        DCL interruptID BYTE;
;
;    This will disable the interrupt of the given ID.  It will not
;    change the state of any other interrupts.

interruptID EQU BYTE PTR [BP+6]

CpDisableInterrupt PROC NEAR
    PUSH DS
    PUSH BP
    MOV  BP, SP

    MOV  BL, interruptID
    MOV  BH, 0
    MOV  AL, CS:interruptMask[BX]   ; AL = mask

    MOV  AH, AL

    PUSHF                           ; save flags
    CLI                             ; disable
    IN   AL, intMask                ; get original mask
    OR   AL, AH
    OUT  intMask, AL                ; OR new one
    POPF                            ; restore flags

    POP  BP
    POP  DS
    RET  2
CpDisableInterrupt ENDP

PURGE interruptID
$EJECT

;    CpSetInterrupt: PROCEDURE (interruptID, pRoutine) PTR CLEAN;
;        DCL interruptID BYTE;
;        DCL pRoutine    PTR;
;
;    This will set up an interrupt vector and return the previous value.

pRoutine    EQU DWORD PTR [BP+6]
interruptID EQU BYTE  PTR [BP+10]

CpSetInterrupt PROC NEAR
   PUSH DS
   PUSH BP
   MOV  BP, SP
   PUSHF
   CLI

   XOR  BX, BX
   MOV  DS, BX                      ; DS = interrupt vectors

   MOV  BL, interruptID
   MOV  BL, CS:interruptTable[BX]   ; BL = real interrupt number

   SHL  BX, 1
   SHL  BX, 1                       ; BX := BX * 4

   ADD  BX, 78H * 4                 ; Add offset of first hardware int vector

   LES  CX, DWORD PTR DS:[BX]       ; get current routine

   PUSH ES                          ; save segment

   LES  DX, pRoutine
   MOV  DS:[BX], DX                 ; save new offset
   MOV  DS:[BX+2], ES               ; save new segment

   POP  ES                          ; return old vector
   MOV  BX, CX

   POPF
   POP  BP
   POP  DS
   RET  6
CpSetInterrupt ENDP

PURGE interruptID, pRoutine
$EJECT

;    CpEndOfInterrupt: PROCEDURE (interruptID) CLEAN;
;        DCL interruptID BYTE;
;
;    This will do a specific "end of interrupt" for the given ID

interruptID EQU BYTE PTR [BP+6]

CpEndOfInterrupt PROC NEAR
   PUSH DS
   PUSH BP
   MOV  BP, SP

   MOV  BH, 0
   MOV  BL, interruptID

   MOV  AL, 060H                    ; AL := specific EOI
   OR   AL, CS: interruptTable[BX]  ; AL := (real interrupt#) OR AL
   OUT  interruptEOI, AL            ; tell the chip

   POP  BP
   POP  DS
   RET  2
CpEndOfInterrupt ENDP

PURGE interruptID
$EJECT

;    CpMachineID: PROCEDURE (pMachineID) CLEAN;
;        DCL pMachineID PTR;
;
;    This will return the 8 byte machine ID

pMachineID EQU DWORD PTR [BP+6]

CpMachineID PROC NEAR
    PUSH DS
    PUSH BP
    MOV  BP, SP

    LES  DI, pMachineID

    MOV  AX, machIdSeg
    MOV  DS, AX                 ; DS:SI ^ machine ID
    MOV  SI, machIdStart
    MOV  CX, 8                  ; loop 8 times

CpMachineLoop:
    MOV  AH, DS:[SI]            ; get 4 bits in high nibble
    ADD  SI, 2                  ; SI ^ next 4 bits

    SHR  AH, 1
    SHR  AH, 1
    SHR  AH, 1                  ; move into low nibble
    SHR  AH, 1                  ; high nibble gets zero

    MOV  AL, DS:[SI]            ; get next 4 bits
    ADD  SI, 2

    AND  AL, 0F0H               ; clear low nibble
    OR   AL, AH                 ; add in low order nibble
    MOV  ES:[DI], AL            ; store in users buffer
    INC  DI

    LOOP CpMachineLoop

    POP  BP
    POP  DS
    RET  4
CpMachineID ENDP

PURGE pMachineID
$EJECT

;    WinGetWindowExtent: PROCEDURE (pExtent) CLEAN;
;        DCL pExtent PTR;
;
;    This will return the window extent.

pExtent EQU DWORD PTR [BP+6]

WinGetWindowExtent PROC NEAR
    PUSH BP
    PUSH DS
    MOV  BP, SP

    XOR  AX, AX             ; use public data table
    MOV  DS, AX             ; to get pointer to
    MOV  SI, 200H           ; screen information
    LDS  SI, DWORD PTR DS:[SI]
    LDS  SI, DWORD PTR DS:[SI+72H]

    CLD
    LES  BX, pExtent
    LODSW                        ; extent X
    MOV  WORD PTR ES:[BX+0], AX  ; Window width
    LODSW                        ; extent Y
    MOV  WORD PTR ES:[BX+2], AX  ; Window height

    POP  DS
    POP  BP
    RET  4
WinGetWindowExtent ENDP
$EJECT

;    WinInvertRectangle: PROCEDURE (pRectangle) CLEAN;
;        DCL pRectangle PTR;
;
;    This will invert a rectangle; given the
;    following conditions.  It must be in the 2nd
;    half of the screen.  The width of the rect
;    must stay within the bounds of a single word.
;    Clipping will not happen.

pRectangle EQU DWORD PTR [BP+6]

topLeftX   EQU  WORD PTR [BX+0]
topLeftY   EQU  WORD PTR [BX+2]
extentX    EQU  WORD PTR [BX+4]
extentY    EQU  WORD PTR [BX+6]

WinInvertRectangle PROC NEAR
    PUSH BP
    PUSH DS
    MOV  BP, SP

    XOR  AX, AX             ; use public data table
    MOV  DS, AX             ; to get pointer to
    MOV  SI, 200H           ; screen information
    LDS  SI, DWORD PTR DS:[SI]
    LDS  SI, DWORD PTR DS:[SI+72H]

    CLD
    LODSW                   ; AX = scrExtentX
    MOV  CL, 3
    SHR  AX, CL             ; (screenExtentX / 8)
    PUSH AX                 ; bytes per row
    SHR  AX, 1              ; (screenExtentX / 16)
    MOV  BX, AX
    PUSH AX                 ; words per row

    LODSW                   ; AX = scrExtentY
    SHR  AX, 1              ; (#rows / 2)
    PUSH AX                 ; halfway point

    SHR  AX, CL             ; divide by 16 to convert
    MUL  BL                 ; to num of paragraphs
    ADD  AX, DS:[SI+2]      ; add original screen SEG
    XCHG DX, AX             ; SEG of 2nd 1/2 of screen


    LDS  BX, pRectangle
    MOV  CX, 10H
    SUB  CX, extentX
    MOV  DI, 0FFFFH
    SHL  DI, CL

    MOV  CX, topLeftX
    AND  CL, 0FH
    SHR  DI, CL

    MOV  AX, topLeftY
    POP  CX                 ; halfway point
    SUB  AX, CX
    POP  CX                 ; words per row
    MUL  CL

    MOV  SI, topLeftX
    MOV  CL, 4
    SHR  SI, CL
    ADD  SI, AX
    SHL  SI, 1

    MOV  CX, extentY        ; Get CX before changing DS
    MOV  DS, DX             ; DS of 2nd 1/2 of screen
    POP  AX                 ; bytes per row
    JCXZ WinInvRectExit

WinInvRectLoop:
    XOR  WORD PTR DS:[SI], DI
    ADD  SI, AX             ; # bytes per row
    LOOP WinInvRectLoop

WinInvRectExit:
    POP  DS
    POP  BP
    RET  4
WinInvertRectangle ENDP
$EJECT

; System Dependant Patching for Interceptor

; This routine patches the address of the printer
; in the compass MsDos public data table.  This 
; way calls to the printer may be rerouted to the
; printer spooler on Server.

SysDepPatchCalls PROC NEAR

    PUSH DS
    PUSH ES
    PUSH SI
    PUSH AX

	   XOR  AX, AX
    MOV  DS, AX                    ; Interrupt Vectors

    MOV  SI, 200H
    LDS  SI, DWORD PTR DS:[SI]     ; @ Compass MsDos Public Data Table
    ADD  SI, 40H                   ; @ Virtual printer driver entrypoint
    MOV  CS:adrPdtPrnOff, SI
    MOV  CS:adrPdtPrnSeg, DS       ; Save @ Virtual printer entrypoint

    LES  AX, DWORD PTR DS:[SI]     ; Virtual Printer Driver Entrypoint
    MOV  CS:oldPdtPrnOff, AX
    MOV  CS:oldPdtPrnSeg, ES       ; Save old Public Data Table Printer Entry

    MOV  DS:[SI+0H], OFFSET PdtPrn
    MOV  DS:[SI+2H], CS            ; Set new PdtPrn entrypoint

    POP  AX
    POP  SI
    POP  ES
    POP  DS

    RET
SysDepPatchCalls ENDP
$EJECT

; System Dependant UnPatching for Interceptor

; This routine insures that the address patched at
; the public data table entry for the printer is
; the same as the one set by this routine.  If it
; is not, then this routine returns with the carry
; flag set.  Otherwise, it restores the original
; pointer.

; No Calls should be unpatched if any of them
; do not belong to this program.

SysDepUnPatchCalls PROC NEAR

    PUSH DS
    PUSH ES
    PUSH SI
    PUSH AX

    MOV  AX, CS                    ; This progs code segment

    LDS  SI, DWORD PTR CS:adrPdtPrnOff
    CMP  AX, WORD PTR DS:[SI+2]
    STC                            ; Error
    JNE  SysDepUnPatchCallsExit

    LES  AX, DWORD PTR CS:oldPdtPrnOff
    MOV  DS:[SI+0], AX
    MOV  DS:[SI+2], ES             ; Restore Pdt Prn

    CLC                            ; No error

SysDepUnPatchCallsExit:
    POP  AX
    POP  SI
    POP  ES
    POP  DS

    RET
SysDepUnPatchCalls ENDP
$EJECT

;   Public Data Table Printer Patch To Interceptor Printer

; On entry registers determine:

; AL = printer ID
;      0 - GPiB printer
;      1 - GPiB plotter
;      2 - Serial printer
;      3 - Serial plotter

; AH = baud rate for serial device

; ES:DI = @buffer to be printed
; CX = number of chars to print

; On exit

; If carry is set, then AX has error code

PdtPrn PROC FAR

    CMP  AL, 3                     ; If for serial
    JAE  PdtPrnGiveBack            ; or GPiB plotter

    CMP  AL, 1                     ; then don't
    JE   PdtPrnGiveBack            ; intercept call

    PUSH AX                        ; save parm
    MOV  AX, SEG DGROUP:timeSlice
    MOV  DS, AX
    MOV  BX, OFFSET charDevAlias
    MOV  AL, DS:[BX+13]            ; if alias prn
    OR   AL, AL                    ; is not set
    POP  AX
    JZ   PdtPrnGiveBack            ; then ignore

    JCXZ PdtPrnExit                ; print 0 chars

PdtPrnTopOfLoop:
    MOV  DL, ES:[DI]               ; get next char

    MOV  AH, 5                     ; print a char
    INT  21H                       ; MsDos call

    INC  DI                        ; next char
    Loop PdtPrnTopOfLoop

PdtPrnExit:
    CLC                            ; No error
    RET

PdtPrnGiveBack:
    JMP  DWORD PTR CS:oldPdtPrnOff

PdtPrn ENDP

CODE ENDS

    END
